<?php

class serv_Model_DbTable_Manut extends Zsam_Db_Table {

    /**
     * The default table name
     */
    protected $_name 		= 'manut';
    var $_autocomplet 		= array('CLIENTE','ITEM');
    //var $regime 			= null;

    var $_conf = array(
        'ID'					=> array("grid"=>true,'edit' => 'N'),
        'ITEM'	         		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
	    'EMPRESA'        		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    	'CLIENTE' 		 		=> array('autocomplete'=>'Y',"grid"=>true,'NULLABLE' => false,'edit' => 'N'),
        'CONTATO'         		=> array('NULLABLE' => false),
        'VENDEDOR'   			=> array('editlevel' => '3'),
        'DATA_ORCAMENTO'		=> array('edit' => 'N'),
		'FECHAR_ORCAMENTO'  	=> array(),
    	'DATA_PREV_ENTREGA' 	=> array(),	
    	'OBS_PREV_ENTREGA' 		=> array(),
    	'DATA_ENTREGA' 			=> array(),
    	'OBS_ENTREGA' 			=> array(),
        'VALOR_TOTAL'    		=> array('edit' => 'N'),
		'DATA_EXECUCAO_SERV'	=> array('title' => 'DATANECESSIDADE'),
        'NUMERO_NF'				=> array('edit' => 'N'),
        'DATA_NF'				=> array('edit' => 'N'),
		'VENCIMENTO'			=> array('title' => 'VENC'),
		'JUROS'					=> array(),
		'ULTIMO_ITEM'    		=> array('edit' => 'N'),
		'TIPO'					=> array(),
        'TIPO_R_L'				=> array(),
		'TIPO_FRETE' 			=> array('VP' => 'FOB,CIF,EXW', 'NULLABLE' => false),
		'VALOR_FRETE' 			=> array(),
		'VALOR_SEGURO' 			=> array(),
        'PRAZO_ENTREGA_DIAS'	=> array(),
        'OBSERVACAO'			=> array(),
        'REFERENCIA_CLIENTE'	=> array("grid"=>true),
        'REFERENCIA_PEDIDO'		=> array(),
		'BAIXA'          		=> array(),
		'DEPARTAMENTO' 			=> array(),
		'STATUS' 				=> array(),
		'STATUS_PADRAO'			=> array(),
		'SITUACAO'        		=> array('title' => 'tem_estoque_S_sim_N_nao_K_falta_num_serie'),
        'APROVACAO'				=> array('edit' => 'N'),
    	

        'GRID'    				=> array('type' 		=> 'itemGrid',
						        		'model' 		=> 'serv_Model_DbTable_Manutitem',
						        		'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','PRODUTO','QUANTIDADE','PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
						        		'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
						        		'buttons'		=> array('edit'=>'S')),
         
        'GRID1'    				=> array('type' 		=> 'itemGrid',
						        		'model' 		=> 'serv_Model_DbTable_Manuthoras',
						        		'controller' 	=> 'Manuthoras',
						        		'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','MVS','NUMERO_HORAS','VALOR_HORA','PRECO_TOTAL_ITEM'),
						        		'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
						        		'buttons'		=> array('edit'=>'N','edit2'=>'S','insert'=>'N','insert2'=>'S','rem' =>'N','rem2'=>'S')),
						        
        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
        'DATA_ALTERACAO' 		=> array('edit' => 'N'),
        'REVISAO'        		=> array('edit' => 'N'),
        'DATASINC'       		=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
        'CLIENTE' => array(
            'columns'       => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CLIENTE'
        ),

		'VENDEDOR' => array(
            'columns'           => 'VENDEDOR',
            'refTableClass'     => 'core_Model_DbTable_Usuario',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENDEDOR'
    	),

    	'VENCIMENTO' => array(
            'columns'           => 'VENCIMENTO',
            'refTableClass'     => 'core_Model_DbTable_Vencimento',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENC'
    	),

    	'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
    	    'semChave'			=> 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

    	'DEPARTAMENTO' => array(
    		'columns'           => 'DEPARTAMENTO',
    		'refTableClass'     => 'core_Model_DbTable_Depto',
    		'refColumns'        => 'DEPARTAMENTO',
    		'refTitle'          => 'DEPARTAMENTO'
    	),

    	'STATUS_PADRAO' => array(
    		'columns'           => 'STATUS_PADRAO',
    		'refTableClass'     => 'core_Model_DbTable_Obsprogr',
    		'refColumns'        => 'CODIGO',
    		'refTitle'          => 'STATUS_PADRAO'
    	),

    	'GRID' => array(
    		'columns' 		=> 'ITEM_PROGR',
    		'refTableClass' => 'serv_ManutitemController',
    		'refColumns' 	=> 'ITEM_PROGR',
    		'refTitle' 		=> 'ITEM'
    	),
    		
    	'GRID' =>  array(
    				'columns' 		=> 'ITEM_PROGR',
    				'refTableClass' => 'serv_Model_DbTable_Manutitem',
    				'refColumns' 	=> 'ITEM_PROGR',
    				'refTitle' 		=> 'ITEM'
    	),
    		 
    	'GRID1' =>  array(
    				'columns' 		=> 'ITEM_PROGR',
    				'refTableClass' => 'serv_Model_DbTable_Manuthoras',
    				'refColumns' 	=> 'ITEM_PROGR',
    				'refTitle' 		=> 'ITEM'
    		)

    );

    public function __construct(){

        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action 	 = $controller->getActionName(); //pegar a controladora

	    $auth = Zend_Auth::getInstance();
		if ($auth->hasIdentity()) {
			$user = $auth->getStorage()->read();
			$funcao = @$user['FUNCAO'];
			$id     = @$user['ID'];
			$nome   = @$user['NOME'];
			$level  = @$user['NIVEL'];
		}

		if($level < 3) $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR =" .$id;
		else $this->_restrict = "FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";

        if($nome_controller == 'programa')
        {
            $this->_conf['DEPARTAMENTO']['NULLABLE'] = FALSE;
            
            if ($nome_action == 'upd')
            {
            	$table  = new Cisweb_Db_Abstract("progr");
            	$venc 	= new Cisweb_Db_Abstract("venc");
            	
            	$id 	= $controller->getParam("id");
            	$id 	= explode(":", $id);
            	$id1 	= $id[0];
            	$id2 	= $id[1];
            	$dados 	= $table->getAdapter()->fetchRow($table->select()->where("CLIENTE = '$id1' AND ITEM = '$id2'"));
     
            	if ($dados['VENCIMENTO'] != '')
            	{
            		$this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO']}'";
            	}
            	else
            	{
            		$this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
            	}	 	
        
            	
            }		
        
        }
        
        if($nome_controller == 'impressaoormclientemanut')
        {
            $this->_restrict = "TIPO = 'O' AND FECHAR_ORCAMENTO = 'S' ";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
        }
        
        if($nome_controller == 'impressaopedidocliente')
        {
        	$this->_restrict = "TIPO = 'P'";
        	$this->_conf['DATA_ORCAMENTO']['grid'] 		= true;
        	$this->_conf['REFERENCIA_CLIENTE']['grid'] 	= false;
        	$this->_conf['REFERENCIA_PEDIDO']['grid'] 	= true;
        	$this->_conf['NUMERO_NF']['grid'] 			= true;
        	$this->_conf['DATA_NF']['grid'] 			= true;
        }

        if($nome_controller == 'reprovaitem')
        {
            $this->_restrict = "TIPO = 'O'";
        }

        if($nome_controller == 'pedidosparafaturar')
        {
            $this->_restrict = "(SITUACAO = 'S' OR SITUACAO = 'K')  AND TIPO = 'P' AND (BAIXA <> 'B' OR BAIXA IS NULL)";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        if($nome_controller == 'pedidosparafaturarsemestoque')
        {
            $this->_restrict = "SITUACAO = 'N' AND TIPO = 'P'";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        parent::__construct();
    }
    
    
    public function calcula_total($id)
    {
    
    	$table 		= new especial_Model_DbTable_Programaveiculoitem();
    	$table2 	= new serv_Model_DbTable_Programa();
    	$cli 		= $id[0];
    	$item 		= $id[1];
    	
    	$dados_item = $table->getAdapter()->fetchAll($table->select()->where("CLIENTE = '$cli' AND ITEM_PROGR = '$item'"));
    	 
      	$total = 0;
    
    	foreach ($dados_item as $key => $value)
    	{
    		$total 		+= $value['PRECO_TOTAL_ITEM'];
    	}
    
    	$data['VALOR_TOTAL'] = $total;
    	
    	$where = "CLIENTE = '$cli' AND ITEM = '$item'";
    	
    	$table2->update($data,$where);
    }


  	public function beforeInsert(array $data) {
        if (is_null($data['TIPO']) || $data['TIPO'] == ''){
			$data['TIPO'] = 'O';
		}
        return parent::beforeInsert($data);
    }
    
    public function getCfop($cli,$emp)
    {
    
    
    	$table_empresa			= new Cisweb_Db_Abstract("empresa");
    	$table_cliente			= new Cisweb_Db_Abstract("cliente");
    	$table_estado			= new Cisweb_Db_Abstract("estados");
    	$table_cidade			= new Cisweb_Db_Abstract("cidades");
    	$table_pais				= new Cisweb_Db_Abstract("paises");
    	$table_cfop				= new Cisweb_Db_Abstract("cfop");
    
    	//Dados da empresa
    	$camposemp 				= $table_empresa->find($emp)->current();
    	$camposcityemp 			= $table_cidade->find($camposemp['CIDADE'])->current();
    	$camposestadoempresa	= $table_estado->find($camposcityemp['UF'])->current();
    	$campospaisempresa		= $table_pais->find($camposestadoempresa['PAIS'])->current();
    
    	//Dados do cliente
    	$camposcli 				= $table_cliente->find($cli)->current();
    	$camposcitycli 			= $table_cidade->find($camposcli['CIDADE'])->current();
    	$camposestadocliente	= $table_estado->find($camposcitycli['UF'])->current();
    	$campospaiscliente		= $table_pais->find($camposestadocliente['PAIS'])->current();
    
    
    	if ($camposestadoempresa['PAIS'] != $camposestadocliente['PAIS'])
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 6999 AND CODIGO < 8000) AND TIPONF = 'F'"));
    
    	}
    	elseif($camposcityemp['UF'] != $camposcitycli['UF'])
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 5999 AND CODIGO < 7000) AND TIPONF = 'F'"));
    
    	}
    	else
    	{
    		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 4999 AND CODIGO < 6000) AND TIPONF = 'F'"));
    
    	}
    
    	return $camposcfop;
    }
}
?>